#!/usr/bin/env python
#coding=utf8

'''
CloudControl Connection related commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command

class Command_uptime(Command):
    '''Show connection uptime'''

    def __call__(self, argv):
        if len(argv) == 1:
            argv.append("a=%s"%self.cli.settings["login"])
        tql = "".join(argv[1:]) + "$con"
        try:
            objs = self.cli.rpc.call("list", tql)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        for o in objs:
            if "a" in o and "con" in o:
                self.printer.out("%s: %ss"%(o["a"], o["con"]))

    def usage(self):
        return "usage: uptime [tql]"

class Command_remote(Command):
    '''Show remote command list'''

    def __call__(self, argv):
        try:
            for cmds in self.cli.rpc.call("list_commands"):
                self.printer.out("%s"%cmds["name"])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: remote"

class Command_whoami(Command):
    '''Show connection login'''

    def __call__(self, argv):
        self.printer.out(self.cli.settings["login"])

    def usage(self):
        return "usage: whoami"

class Command_kill(Command):
    '''Kill a server connection'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("kill", argv[1])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: kill <tql>"
