#!/usr/bin/env python
#coding=utf8

'''
CloudControl shells related commands
'''

from cccli.exception import *
from cccli.printer import Printer, color
from cccli.command.command import Command

class Command_quit(Command):
    '''Quit application with respect'''
    def __call__(self, argv):
        raise SystemExit()

    def usage(self):
        return "usage: quit"


class Command_version(Command):
    '''Print cli version'''
    def __call__(self, argv):
        import cccli
        self.printer.out(cccli.version)

    def usage(self):
        return "usage: version"


class Command_history(Command):
    '''Show commands history'''
    def __call__(self, argv):
        if not self.printer.history:
            raise cmdError("not available")
        for l in self.printer.history:
            self.printer.out(l)

    def usage(self):
        return "usage: history"


class Command_help(Command):
     '''Print help'''
     def __call__(self, argv):
         if len(argv) == 1:
             # printing commands list
             width = max(map(len, self.cli.commands)) + 3
             self.printer.out("%sCommands:%s"%(color["lwhite"], color["reset"]))
             for c in sorted(self.cli.commands):
                 line = "%s"%c
                 line = line.ljust(width,)
                 line += "- %s"%self.cli.commands.help(c)
                 self.printer.out(line)
         elif len(argv) == 2:
             if argv[1] not in self.cli.commands:
                 raise cmdBadArgument(argv[1])
             self.printer.out(self.cli.commands.help(argv[1]))
             self.printer.out(self.cli.commands.usage(argv[1]))
         else:
             raise cmdBadArgument()

     def usage(self):
         return "usage: help [command]"


class Command_usage(Command):
    '''Print usage of a command'''

    def __call__(self, argv):
        if len(argv) != 2:
            raise cmdBadArgument()
        usage = self.cli.commands.usage(argv[1])
        if usage is None:
            self.printer.out("No usage.")
        else:
            self.printer.out(usage)

    def usage(self):
        return "usage: usage <command>"


class Command_clear(Command):
    '''Clear tty'''

    def __call__(self, argv):
        self.printer.out("\033[H\033[2J", nl="")

    def usage(self):
        return "usage: clear"
