#!/usr/bin/env python
#coding=utf8

'''
CloudControl tag releated commands
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import Command

from optparse import OptionParser

class Command_tags(Command):
    '''List static tags on an account (current by default)'''

    def __call__(self, argv):
        # Parse argline
        try:
            oparser = OptionParser(prog=argv[0])
            oparser.add_option("--raw", action="store_true", dest="raw",
                               help="Don't append filter on request")
            (options, args) = oparser.parse_args(argv[1:])
        except SystemExit:
            return
        # append current login if nothing asked
        if len(args) == 0:
            tql = "a=%s"%self.cli.settings["login"]
        else:
            tql = "".join(args)
        # update tql if mode
        if not options.raw:
            tql += "&a"
        # ask server
        try:
            objs = self.cli.rpc.call("tags", tql)
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))
        # display answer
        for o in objs:
            id = o.pop("id")
            tags = " ".join([ "%s%s:%s%s"%(color["green"], t, color["reset"], v) for (t,v) in o.items() ])
            self.printer.out("%sid:%s%s%s %s"%(color["green"], color["yellow"], id, color["reset"], tags))

    def usage(self):
        return "usage: tags [--raw] [--help] [tql]"


class Command_addtag(Command):
    '''Add/Modify a static tag on an account'''

    def __call__(self, argv):
        if len(argv) != 4:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("addtag", argv[1], argv[2], argv[3])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: addtag <tql> <tag> <value>"


class Command_deltag(Command):
    '''Delete a static tag from an account'''

    def __call__(self, argv):
        if len(argv) != 3:
            raise cmdBadArgument()
        try:
            self.cli.rpc.call("deltag", argv[1], argv[2])
        except RpcError as e:
            raise cmdError("RPCError: %s"%str(e))

    def usage(self):
        return "usage: deltag <tql> <tag>"
