#!/usr/bin/env python
#coding=utf8

'''
CloudControl migrate command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

class Command_migrate(TqlCommand):
    '''Migrate vm'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <source tql> <dest tql>")
        self.remove_option("--direct")
        self.remove_option("--raw")
        self.remove_option("--print-tql")
        self.add_option("-l", "--list", action="store_true", dest="list", default=False,
                        help="List migration types and algo")
        self.add_option("-t", "--type", action="store", dest="type", default="",
                        help="Selection migration type")
        self.add_option("-a", "--algo", action="store", dest="algo", default="",
                        help="Select migration algorithm")

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        # Retrieve election types
        self.etypes = self.get_electiontypes()
        # Check args and do listings
        if self.options.list:
            self.list()
            return
        elif self.options.type not in self.etypes:
            raise cmdBadArgument("No such type: %s"%self.options.type)
        elif self.options.algo not in self.etypes[self.options.type]:
            raise cmdBadArgument("No such algo: %s for type: %s"%(self.options.algo, self.options.type))
        elif len(self.args) != 2:
            raise cmdBadArgument()
        stql = self.args[0]
        dtql = self.args[1]
        # election(query_vm, query_dest, mtype='cold', algo='fair', **kwargs)
        scrutin = self.rpccall("election", stql, dtql,
                               mtype=self.options.type,
                               algo=self.options.algo,
                               _direct=True, _status=False)
        # check election result
        if len(scrutin) == 0:
            raise cmdError("No migration plan found")
        # print election
        for (i,o) in enumerate(scrutin):
            if self.options.index:
                self.printer.out("[%d] "%i, nl="")
            self.printer.out("%s%s %s-> %s%s%s (%s)"%(
                    self.tdc("id"),
                    o["sid"],
                    color["reset"],
                    self.tdc("id"),
                    o["did"],
                    color["reset"],
                    o["type"]))
        # ask confirmation
        if self.printer.ask("Do you confirm election? (Yes baby) ") != "Yes baby":
            raise cmdWarning("User resign")
        # run migration
        self.rpccall("migrate", scrutin, _direct=True)

    def get_electiontypes(self):
        '''Return a list of migration type'''
        try:
            return self.cli.rpc.call("electiontypes")
        except RpcError as e:
            raise cmdError(e)

    def list(self):
        '''Print a list of migration type'''
        for t in self.etypes.keys():
            self.printer.out("migrate -t %s -a %s"%(t, ",".join(self.etypes[t])))
