#!/usr/bin/env python
#coding=utf8

'''
CloudControl jobs command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand

class Command_jobs(TqlCommand):
    '''List jobs'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")
        self.remove_option("--quiet")
        self.remove_option("--direct")
        self.add_option("-d", "--done", action="store_true", dest="done", default=False,
                        help="Show done jobs")
        self.add_option("-R", "--no-running", action="store_false", dest="running", default=True,
                        help="Don't show running jobs")

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        # append current login if nothing asked
        if len(self.args) == 0:
            tql = ""
        else:
            tql = "".join(self.args)
        # ask server
        objs = self.rpccall("jobs", tql,
                            _direct=True,
                            _status=False,
                            show_done=self.options.done,
                            show_running=self.options.running)
        self.print_objects(objs, index=self.options.index)
