#!/usr/bin/env python
#coding=utf8

'''
CloudControl jobs command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import OptionCommand

class Command_cancel(OptionCommand):
    '''Cancel a job'''

    def __init__(self, cli, argv0):
        OptionCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] <job_id> ...")

    def __call__(self, argv):
        # Parse argline
        self.parse_args(argv)
        # append current login if nothing asked
        if len(self.args) == 0:
            raise cmdBadArgument()
        # ask server
        for jid in self.args:
            try:
                self.cli.rpc.call("cancel", int(jid))
                self.printer.out("Job %s: cancelled."%jid)
            except ValueError:
                self.printer.error("Invalid job id: %s"%jid)
            except RpcError as e:
                self.printer.error("%s"%e)
