#!/usr/bin/env python
#coding=utf8

'''
CloudControl CLI RPC Handler
'''

from cccli.exception import *
from cccli.printer import Printer, color
from sjrpc.client import SimpleRpcClient
from sjrpc.utils import RpcHandler, pure
from sjrpc.core.exceptions import *
import cccli
import os, os.path
import subprocess
import platform


class CliHandler(RpcHandler):
    '''Handle RPC incoming request'''

    @pure
    def quit(self, rpc=None):
        '''Call back function on server disconnect'''
        Printer().fatal("Disconnected from server!")

    @pure
    def get_tags(self, complete=None, partial=None):
        '''Return a dict of local tags'''
        # prepare work
        taglist = [ x[8:] for x in dir(self) if x.startswith("get_tag_") ]
        ctag = set(taglist) if complete is None else set(complete)
        ptag = set(taglist) if partial is None else set(partial)
        d = dict()
        # remove unknown tags
        ctag.intersection_update(taglist)
        ptag.intersection_update(taglist)
        # build partial tags
        for t in ptag:
            d[t] = { "ttl": getattr(self, "get_tag_%s"%t).ttl }
        # build complete tags
        for t in ctag:
            method = "get_tag_%s"%t
            d[t] = { "value": getattr(self, method)(), "ttl": getattr(self, method).ttl}
        # answer
        return d

    def get_tag_version(self):
        '''Return tag version'''
        return cccli.version
    get_tag_version.ttl = -1

    def get_tag_os(self):
        '''Return Operating system tag'''
        return platform.system().lower()
    get_tag_os.ttl = -1

    def get_tag_uname(self):
        '''Return uname output'''
        try:
            p = subprocess.Popen(["uname", "-a"], close_fds=True, shell=False, stdout=subprocess.PIPE)
            return  p.stdout.read().rstrip("\n")
        except Exception:
            return ""
    get_tag_uname.ttl = -1

    def get_tag_uptime(self):
        '''Return uptime output'''
        try:
            return int(float(open("/proc/uptime", "r").readline().split()[0]))
        except Exception:
            return ""
    get_tag_uptime.ttl = 3
