#!/usr/bin/env python
#coding=utf8

'''
CloudControl list command
'''

from cccli.exception import *
from sjrpc.core.exceptions import *
from cccli.printer import Printer, color
from cccli.command.command import TqlCommand
import math

class Command_list(TqlCommand):
    '''List objects'''

    def __init__(self, cli, argv0):
        TqlCommand.__init__(self, cli, argv0)
        self.set_usage("%prog [options] [tql]")
        self.add_option("-t", action="store_true", dest="table",
                        help="column aligment display")
        self.add_option("-l", action="store_true", dest="align",
                        help="line aligment display")
        self.remove_option("--quiet")
        self.remove_option("--direct")

    def __call__(self, argv):
        self.parse_args(argv)
        if len(self.args) == 0:
            self.args.append("")
        objs = self.rpccall("list", str.join("", self.args), _status=False, _direct=True)
        if len(objs) == 0:
            return
        if self.options.align:
            self.list_align(objs)
        elif self.options.table:
            self.list_table(objs)
        else:
            self.print_objects(objs, index=self.options.index)

    def list_align(self, objs):
        '''Listing line aligned'''
        # get max size by tag
        tags = dict()
        for o in objs["objects"]:
            for (t,v) in o.items():
                tags[t] = max(len(self.tdr(t, v)), tags.get(t, 0))
        # build initial print order
        order = [ t for t in objs.get("order", []) if t in tags ]
        order.extend(sorted(set(tags.keys()) - set(order)))
        # compute index width
        indexw = int(math.log10(len(objs["objects"])))
        # dislay each object by line
        for (i,o) in enumerate(objs["objects"]):
            if self.options.index:
                line = ("[%d]"%i).ljust(indexw + 4)
            else:
                line = ""
            for t in order:
                line += "%s%s:%s%s "%(self.tdtc(t),
                                      t,
                                      self.tdc(t),
                                      self.tdr(t, o.get(t, u"")).ljust(tags[t]))
            self.printer.out("%s%s"%(line, color["reset"]))

    def list_table(self, objs):
        '''Listing table style'''
        # get max size by tag
        tags = dict()
        for o in objs["objects"]:
            for (t,v) in o.items():
                tags[t] = max(len(self.tdr(t, v)), tags.get(t, len(t)))
        # build initial print order
        order = [ t for t in objs.get("order", []) if t in tags ]
        order.extend(sorted(set(tags.keys()) - set(order)))
        if self.options.index:
            # compute index width
            indexw = max(int(math.log10(len(objs["objects"]))+1), len("index "))
            # print index title
            self.printer.out("index ", nl="")
        # print tag title in order
        for t in order:
            self.printer.out(self.tdtc(t), nl="")
            self.printer.out(t.ljust(tags[t]), nl=" ")
        self.printer.out(color["reset"])
        # print tags in order
        for (i,o) in enumerate(objs["objects"]):
            for t in order:
                if self.options.index:
                    self.printer.out(("%d "%i).ljust(indexw), nl="")
                self.printer.out(self.tdc(t), nl="")
                self.printer.out(self.tdr(t, o.get(t, u"")).ljust(tags[t]) ,nl=" ")
            self.printer.out(color["reset"])
